﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using Verse;


namespace RimWorld{
public class IncidentWorker_HeatWave : IncidentWorker_MakeMapCondition
{
	protected override bool CanFireNowSub(IIncidentTarget target)
	{
		if( !base.CanFireNowSub(target) )
			return false;

		var map = (Map)target;

		if( map.mapTemperature.SeasonalTemp < 20 )
			return false;

		return true;
	}
}

public class IncidentWorker_ColdSnap : IncidentWorker_MakeMapCondition
{
	protected override bool CanFireNowSub(IIncidentTarget target)
	{
		if( !base.CanFireNowSub(target) )
			return false;

		var map = (Map)target;

		if( map.mapTemperature.SeasonalTemp < 0 || map.mapTemperature.SeasonalTemp > 10 )
			return false;

		return true;
	}
}
}